unit Bdetool1;

(*
a little demo on how to use those BDE calls with Delphi code.

version 1.1 adds some more db related gimmicks and some
simple form sizing routines (form size, prevent sizing,
center etc)... and don't miss the pop-up menu....

as v1.0 was not exactly a good example regarding the potential
loss of ressources, a more appropriate error handling has also
been added.

this 'app' is still by no means error proof, it's just meant to
give some hints!

for more information on using DBI* functions, refer to the
DBI*.INT files in \delphi\doc and download BDEHLP.ZIP from
CIS/Delphi.

this is free, and I won't take any responsibility for your data!
please be careful using these functions, esp. with protecting
tables!

comments appreciated nevertheless... being a Paradox user there
might be some quirks esp. with dBase tables. I'd be glad if you
told me.

Reinhard Kalinke
100417,3504@compuserve.com
may 27, 1996

P.S. and BTW: if you want to use pictures and valchecks with your
Paradox tables, have a look at PICEDITS.ZIP in lib 5 and another
at PXVALTBL.ZIP in lib 6 of CIS/Delphi...

*)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, Grids, DBGrids, FileCtrl,
  DBIProcs, DBITypes, DBIErrs, ExtCtrls, DBCtrls, Mask, Menus, TabNotBk;

type
  TMainFrm = class(TForm)
    PackBtn: TButton;
    CopyBtn: TButton;
    ProtectBtn: TButton;
    FileNameInfo: TEdit;
    Table1: TTable;
    DataSource1: TDataSource;
    SaveDialog1: TSaveDialog;
    Bevel1: TBevel;
    Label1: TLabel;
    Panel1: TPanel;
    DBNavigator1: TDBNavigator;
    RenameBtn: TButton;
    DeleteBtn: TButton;
    UserBtn: TButton;
    Database1: TDatabase;
    Panel2: TPanel;
    Bevel2: TBevel;
    PopupMenu1: TPopupMenu;
    Showhints1: TMenuItem;
    DBGrid1: TDBGrid;
    GotoRecNo1: TMenuItem;
    SelGridFields1: TMenuItem;
    N1: TMenuItem;
    AllowRearrange1: TMenuItem;
    NoRearrange1: TMenuItem;
    Showgridindicator1: TMenuItem;
    TabbedNotebook1: TTabbedNotebook;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    FileListBox2: TFileListBox;
    ListBox1: TListBox;
    IndexCombo: TComboBox;
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure FileListBoxesChange(Sender: TObject);
    procedure Table1AfterOpen(DataSet: TDataset);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure CopyBtnClick(Sender: TObject);
    procedure RenameBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure PackBtnClick(Sender: TObject);
    procedure ProtectBtnClick(Sender: TObject);
    procedure UserBtnClick(Sender: TObject);
    procedure DBGrid1ColEnter(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TryOpenExclusive(Tbl: TTable; bOpen, bExcl: boolean);
    procedure Showhints1Click(Sender: TObject);
    procedure Action(IsOn: boolean);
    procedure GotoRecNo1Click(Sender: TObject);
    procedure GridFields1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Showgridindicator1Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure IndexComboChange(Sender: TObject);
    procedure Table1BeforeClose(DataSet: TDataset);
  private
    { Private-Deklarationen }
    FPreventSizing: boolean;
    FTblProps: CURProps;
    function GetFileName(var NewName: TFileName):boolean;
    procedure SaveOnIdle(Sender: TObject; var Done: boolean);
    procedure HandleException(Sender: TObject; E: Exception);
    procedure UpdateIndexCombo(ATable: TTable);
    procedure ShowRowCol;
    procedure WMGetMinMaxInfo(var Msg: TWMGetMinMaxInfo);
              message WM_GETMINMAXINFO;
    procedure WMInitMenuPopup(var Msg: TWMInitMenuPopup);
              message WM_INITMENUPOPUP;
    procedure WMNCHitTest(var Msg: TWMNCHitTest);
              message WM_NCHitTest;
  public
    { Public-Deklarationen }
  end;

  TDBGridHack = class(TDBGrid); {for accessing row/col in a DBGrid,
                                 idea taken from Lloyd's help file}
var
  MainFrm: TMainFrm;

const
  PrimaryName = 'Primary *';
  NoIndexName = 'base order';

procedure BDECheck(BDERes: DBIResult);
procedure CalcControlSize(AWinControl: TWinControl);
function CloseTableQuery(ADataset: TDataset): boolean;
function FindPrevInst(Wnd: HWnd; clientData: Longint): Bool; export;

implementation

{$R *.DFM}
{$B-}

uses BDETool2;

{row/col display part I:}
procedure TMainFrm.ShowRowCol;
var iGridCol: smallint;
begin
  with TDBGridHack(DBGrid1) do
  begin
    iGridCol := Col;
    if not (dgIndicator in DBGrid1.Options) then inc(iGridCol);
    Panel2.Caption := IntToStr(Row) + '/' + IntToStr(iGridCol);
  end;
end;

{row/col display part II:}
procedure TMainFrm.DBGrid1ColEnter(Sender: TObject);
begin
  ShowRowCol;
end;

{the RecordNo panel and row/col display part III:
(also have a look at the more generic GetCurrentRecNo proc)}
{NOTE for dBase tables with an active index the reported recno will
 still be the physical sort no! (one more point for Pdox...<g>) }
procedure TMainFrm.DataSource1DataChange(Sender: TObject; Field: TField);
var RcrdProps: RECProps;  {req for dBase only}
    RcrdNo: longint;
    BDERes: DBIResult;
begin
  {row/col display:}
  if (Sender as TDataSource).State = dsBrowse then ShowRowCol;
  {recNo display:}
  with Table1 do
  begin
    BDERes := 0;
    UpdateCursorPos;
    if BOF then
      RcrdNo := 1
    else
      if EOF then
        RcrdNo := RecordCount
      else
      {you can use DBIGetRecord on both (like in GetCurrentRecNo),
       but I wanted to include DBIGetSeqNo to show how to do it
       more easily in Paradox-only apps:}
        if StrPas(FTblProps.szTableType) = szPARADOX then
          BDERes := DBIGetSeqNo(Handle,RcrdNo)
        else
        begin
          BDERes := DBIGetRecord(Handle,dbiNOLOCK,nil,@RcrdProps);
          RcrdNo := RcrdProps.iPhyRecNum;
        end;
    {CursorPosChanged; can cause some confusion with the
                       Grid's indicator. You'd better call ->}
    UpdateCursorPos;
    if BDERes = 0 then
      Panel1.Caption := IntToStr(RcrdNo)+' of '+IntToStr(RecordCount)
    else
      Panel1.Caption := '??? of '+IntToStr(RecordCount);
  end; {with Table1}
end;

function GetCurrentRecNo(ADataSet: TDBDataSet):longint;
var SetProps: CURProps;
    RcrdProps: RECProps;
    {used here because I didn't want to raise an exception
    with BDECheck() but only return -1 if the function fails:}
    BDERes: DBIResult;
begin
  Result := -1;
  with ADataSet do
  begin
    UpdateCursorPos;
    if BOF then Result := 1
    else
      if EOF then Result := RecordCount
      else
      begin
        BDERes := DBIGetCursorProps(Handle,SetProps);
        if BDERes = DBIERR_NONE then
          BDERes := DBIGetRecord(Handle,dbiNOLOCK,nil,@RcrdProps);
        if BDERes = DBIERR_NONE then
          case SetProps.iSeqNums of
            0: Result := RcrdProps.iPhyRecNum;
            1: Result := RcrdProps.iSeqNum;
          end;
      end;
  end; {with ADataSet}
end;

function SetToRecNo(ADataSet: TDBDataSet; ARecNo: longint): boolean;
var BDERes: DBIResult;
    SetProps: CURProps;
begin
  Result := False;
  with ADataSet do
  begin
    BDERes := DBIGetCursorProps(Handle,SetProps);
    if (BDERes = DBIERR_NONE) then
    begin
      case SetProps.iSeqNums of
        0: BDERes := DBISetToRecordNo(Handle,ARecNo); {dBase}
        1: BDERes := DBISetToSeqNo(Handle,ARecNo); {Paradox}
      end;
      {CursorPosChanged; {is not working, you need a ->}
      Refresh;
    end;
    Result := (BDERes = DBIERR_NONE)
  end;
end;

procedure TMainFrm.GotoRecNo1Click(Sender: TObject);
var sJumpNo: TSymbolStr;
begin
  sJumpNo := IntToStr(GetCurrentRecNo(Table1));
  if InputQuery('Go to RecordNo',
                'Enter the number you want to jump to:',
                sJumpNo) then
    if not SetToRecNo(Table1,StrToInt(sJumpNo)) then
      ShowMessage('Could not find this record');
end;

procedure TMainFrm.Table1AfterOpen(DataSet: TDataset);
begin
  {we will need this info in a couple of situations:}
  DBIGetCursorProps(Table1.Handle,FTblProps);
  {setting the action panel}
  Action(true);
  {updating index display}
  UpdateIndexCombo(DataSet as TTable);
end;

procedure TMainFrm.Table1BeforeClose(DataSet: TDataset);
begin
  if not CloseTableQuery(DataSet) then
    SysUtils.Abort;
  {invalidate table cursor info:}
  FillChar(FTblProps,sizeOf(CURProps),0);
end;

procedure TMainFrm.Action(IsOn: boolean);
{only a gimmick here but can be quite useful if you need the
value more than once:}
const caActionStr: array[boolean] of TFileExt = ('off','on');
var IsExcl: boolean;
begin
  IsOn := IsOn and Table1.Active; {won't hurt...}
  IsExcl := IsOn and Table1.Exclusive;
  CopyBtn.Enabled := IsOn;
  PackBtn.Enabled := IsExcl;
  RenameBtn.Enabled := IsExcl;
  DeleteBtn.Enabled := IsExcl;
  ProtectBtn.Enabled := IsExcl and (StrPas(FTblProps.szTableType)
                                     = szPARADOX);
  Label1.Caption := ' Action is '+caActionStr[IsOn]+' ';
  UpdateIndexCombo(Table1);
  if not Table1.Active then
  begin
    Panel1.Caption := 'RecordNo';
    Panel2.Caption := 'RowCol';
  end
  else
    FileNameInfo.Text := FileNameInfo.Text+' / '
                         +StrPas(FTblProps.szTableType)
                         +' v'+IntToStr(FTblProps.iTblLevel);
end;

procedure TMainFrm.TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  FileListBoxesChange(Self.FindComponent('FileListBox'
                       +IntToStr(NewTab+1)));
  {switch the FileName edit box to the other filelist...}
  (Self.FindComponent('FileListBox'
    +IntToStr(2-NewTab)) as TFileListBox).FileEdit := nil;
  (Self.FindComponent('FileListBox'
    +IntToStr(NewTab+1)) as TFileListBox).FileEdit := FileNameInfo;
end;

procedure TMainFrm.DirectoryListBox1Change(Sender: TObject);
begin
  with Table1 do
    if Active then Close;
  Action(False);
  with DataBase1 do
  begin
    Close;
    DriverName := 'STANDARD';
    Params.Clear;
    Params.Add('PATH='+DirectoryListBox1.Directory);
    Open;
  end;
end;

procedure TMainFrm.ListBox1Click(Sender: TObject);
var PathList: TStringList;
begin
  with ListBox1, DataBase1 do
  begin
    if (ItemIndex <> -1)
    and (Items[ItemIndex] <> AliasName) then
    begin
      Close;
      AliasName := Items[ItemIndex];
      Params.Clear;
      Open;
      PathList := TStringList.Create;
      try
        Session.GetAliasParams(Items[ItemIndex], PathList);
        with FileListBox2, PathList do
          Directory := copy(Strings[0],
                            pos('=',Strings[0])+1,
                            length(Strings[0])-pos('=',Strings[0]));
      finally
        PathList.Free;
      end;
    end;
  end;
end;

procedure TMainFrm.FileListBoxesChange(Sender: TObject);
begin
  with (Sender as TFileListBox), Table1 do
  begin
    if Active then Close;
    if FileName <> '' then
    begin
      TableName := ExtractFileName(FileName);
      IndexName := '';
      TryOpenExclusive(Table1, True, True);
      DBGrid1.SetFocus;
    end
    else
      Action(False);
  end;
end;


function TMainFrm.GetFileName(var NewName: TFileName):boolean;
begin
  with SaveDialog1 do
  begin
    NewName := '';
    Result := False;
    {tell the tabletype without FTblProps this time:}
    DefaultExt := copy(ExtractFileExt(Table1.TableName),2,3);
    if (Uppercase(DefaultExt) = 'DBF') then
      Filter := 'dBase tables|*.dbf'
    else
      Filter := 'Paradox tables|*.db';
   Result := Execute;
    if Result then
      NewName := Filename;
    if Result and (ofExtensionDifferent in Options) then
    begin
      Result := not Result;
      {raising an invalid filename error:}
      DBIError(DBIERR_INVALIDFILENAME);
    end;
  end; {with SaveDialog1}
end;

procedure TMainFrm.UpdateIndexCombo(ATable: TTable);
begin
  IndexCombo.Items.Clear;
  with ATable do
  begin
    if Active then
    begin
      IndexDefs.Update;
      GetIndexNames(IndexCombo.Items);
      IndexCombo.Items.Insert(0,NoIndexName);
      if (StrPas(FTblProps.szTableType) = szParadox) then
        if IndexDefs.Count > 0 then
          IndexCombo.Items[0] := PrimaryName;
    end
    else
      IndexCombo.Items.Add('Indices');
    IndexCombo.ItemIndex := 0;
  end;
end;

procedure TMainFrm.IndexComboChange(Sender: TObject);
begin
  if (IndexCombo.Text = PrimaryName)
  or (IndexCombo.Text = NoIndexName) then
    Table1.IndexName := ''
  else
    Table1.IndexName := IndexCombo.Text;
end;

procedure TMainFrm.FormCreate(Sender: TObject);
begin
  {checking for previous instance of this app: (16bit only)}
  if HPrevInst <> 0 then
    EnumWindows(@FindPrevInst, 0);
  { calculate FormSize by lower right corner
  to make sure that the whole form is shown: }
  CalcControlSize(self);
  FPreventSizing := True;
  Application.OnIdle := SaveOnIdle;
  Application.OnException := HandleException;
  Application.HintPause := 2500;
  Application.Showhint := Showhints1.Checked;
  {reading aliases of the current idapi.cfg:}
  Session.GetAliasNames(ListBox1.Items);
  FileListBox2.Items.Clear;
  {initializing database connection:}
  DirectoryListBox1Change(DirectoryListBox1);
  {starting page:}
  TabbedNoteBook1.PageIndex := 0;
  {init IndexCombo:}
  UpdateIndexCombo(Table1);
  {this makes the app respect the ProgMan 'Run minimized' option:}
  ShowWindow(Handle, cmdShow);
end;


{ this routine is written by Roy Nelson of Borland UK
and handles all windowstates correctly}
{ he said you are allowed to include this in your app when you
agree to buy him a beer when you happen to meet him in a bar <s>}
function FindPrevInst(Wnd: HWnd; clientData: Longint): Bool;
var
  WndClass, WndText: array[0..255] of char;
begin
  Result := True;
  { Concentrate solely on our EXE }
  if GetWindowWord(Wnd, gww_HInstance) = HPrevInst then
  begin
    GetClassName(Wnd, WndClass, Pred(SizeOf(WndClass)));
    GetWindowText(Wnd, WndText, Succ(Length(Application.MainForm.Caption)));
    { Normally first window will be Application's }
    { but if the app started minimised, it will be the main form's }
    if (StrPas(WndClass) = Application.ClassName) or
       ((StrPas(WndText) = Application.MainForm.Caption) and
        IsIconic(Wnd)) then
    begin
      { This technique is used by the VCL - post a message }
      { then bring the window to the top, before the message }
      { gets processed }
      PostMessage(Wnd, wm_SysCommand, sc_Restore, 0);
      BringWindowToTop(Wnd);
      Halt;
    end;
  end;
end;

procedure TMainFrm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var i: smallint;
begin
  {it's only one table here, but nevertheless...:}
  for i:=0 to Database1.DatasetCount-1 do
    CanClose := CloseTableQuery(Database1.Datasets[i]);
  {with more than one databases you can step the
  Session.DataBases[i].Datasets[j] array...}
end;

{---- more gimmicks -------}

procedure TMainFrm.PopupMenu1Popup(Sender: TObject);
begin
  GotoRecNo1.Enabled := Table1.Active;
  SelGridFields1.Enabled := Table1.Active;
  Showgridindicator1.Checked := (dgIndicator in DBGrid1.Options);
end;

procedure TMainFrm.GridFields1Click(Sender: TObject);
var i: smallint;
begin
  with TSelFldsFrm.Create(self) do
  begin
    Table1.DisableControls;
    try
      Caption := 'Select Grid Fields';
      SetRearrangeMode(Sender = AllowRearrange1);
      InitGridFields(Table1);
      SetCenterPos;
      ShowModal;
      if (ModalResult = mrOk) then
        SetGridFields(Table1);
    finally
      Free;
      Table1.EnableControls;
    end;
  end;
end;

procedure TMainFrm.Showgridindicator1Click(Sender: TObject);
begin
  with DBGrid1 do
    if (dgIndicator in Options) then
      Options := Options - [dgIndicator]
    else
      Options := Options + [dgIndicator];
  ShowRowCol;
end;

procedure TMainFrm.Showhints1Click(Sender: TObject);
begin
  Showhints1.Checked := not Showhints1.Checked;
  Application.Showhint := Showhints1.Checked;
end;

procedure TMainFrm.TryOpenExclusive(Tbl: TTable; bOpen, bExcl: boolean);
begin
  {make sure we have exclusive access/reset exclusive:}
  with Tbl do
  begin
    if (Exclusive<>bExcl) then
    begin
      if Active then Close;
      Exclusive := bExcl;
    end;
    try Active := bOpen;
    except {try again non-exclusive:}
      if bExcl then Exclusive := False;
      try Active := bOpen;
      except
        Action(False); {inform buttons...}
        raise;
      end;
    end;
  end;
end;

{--- prevent sizing -----}

procedure TMainFrm.WMGetMinMaxInfo(var Msg: TWMGetMinMaxInfo);
begin
  inherited;
  if FPreventSizing then
    with (self), Msg.MinMaxInfo^ do
    begin
      ptMinTrackSize.x:= Width;
      ptMaxTrackSize.x:= Width;
      ptMinTrackSize.y:= Height;
      ptMaxTrackSize.y:= Height;
    end;
end;

procedure TMainFrm.WMInitMenuPopup(var Msg: TWMInitMenuPopup);
begin
  inherited;
  if FPreventSizing and Msg.SystemMenu then
    EnableMenuItem(Msg.MenuPopup, SC_SIZE, MF_BYCOMMAND or MF_GRAYED)
end;

procedure TMainFrm.WMNCHitTest(var Msg: TWMNCHitTest);
begin
  inherited;
  if FPreventSizing then
    with Msg do
      if Result in [HTLEFT, HTRIGHT, HTBOTTOM, HTBOTTOMRIGHT,
                    HTBOTTOMLEFT, HTTOP, HTTOPRIGHT, HTTOPLEFT] then
         Result:= HTNOWHERE;
end;

procedure TMainFrm.HandleException(Sender: TObject; E: Exception);
begin
  ShowMessage(E.Message);
end;


{-- 'public' tool procs --}

{used to set a container control's size so that all it's controls
 are visible without being cut or introducing a scrollbar. This
 is for example useful for showing forms at different solutions
 without using any scaling.}
procedure CalcControlSize(AWinControl: TWinControl);
var i, CBorder, CWidth, CHeight: smallint;
begin
  if (AWinControl.ComponentCount=0) then exit;
  with AWinControl do
  begin
    CWidth := 0;
    CHeight := 0;
    CBorder := Width;
    for i:=0 to pred(ComponentCount) do
      if (Components[i] is TControl) {to include TBevel...}
      and TControl(Components[i]).Visible
      and (TControl(Components[i]).Parent = AWinControl) then
        with TControl(Components[i]) do
        begin
          if (Left < CBorder) then
            CBorder := Left;
          if (Left+Width > CWidth) then
            CWidth := Left+Width;
          if (Top+Height > CHeight) then
            CHeight := Top+Height;
        end;
    CWidth := CWidth+CBorder+(Width-ClientWidth);
    CHeight := CHeight+CBorder+(Height-ClientHeight);
    SetBounds(Left,Top,CWidth,CHeight);
  end;
end;

{----------- the dbi stuff --------------}

procedure TMainFrm.CopyBtnClick(Sender: TObject);
var NewTblName: TFileName;
    pSrcTblName, pDestTblName: DBITBLNAME;
begin
  if GetFileName(NewTblName) then
  begin
    with Table1 do
    begin
      {processing of 'foreign' characters:}
      AnsiToNative(DBLocale,TableName,pSrcTblName,255);
      AnsiToNative(DBLocale,NewTblName,pDestTblName,255);
      BDECheck( DBICopyTable(DBHandle,
                   False,        {Overwrite, if table already exists}
                   pSrcTblName,  {sourcetablename}
                   nil,    {tabletype, can be nil if filenames have extensions}
                   pDestTblName) ); {desttablename}
      {Updating the filelist:}
      with (Self.FindComponent('FileListBox'
      +IntToStr(succ(TabbedNoteBook1.PageIndex)))
      as TFileListBox) do
      begin
        Update;
        FileName := TableName;
      end;
    end;
  end;
end;

procedure TMainFrm.RenameBtnClick(Sender: TObject);
var pSrcTblName, pDestTblName: DBITBLNAME;
    NewTblName: TFileName;
    hDB: hDBIdb;
    RLocale: TLocale;
begin
  {NOTE this can also be done with Table1.RenameTable('NewName')
  it's not documented in the manuals/OLH but in \delphi\manuals.txt}
  if GetFileName(NewTblName) then
  begin
    with Table1 do
    begin
      {save dbhandle and dblocale,
       we will have to close that table:}
      hDB := DBHandle;
      RLocale := DBLocale;
      AnsiToNative(RLocale,TableName,pSrcTblName,255);
      AnsiToNative(RLocale,NewTblName,pDestTblName,255);
      Close;
      try
        BDECheck( DBIRenameTable(hDB, {db handle}
                     pSrcTblName,   {sourcetablename}
                     nil,    {tabletype, can be nil if filenames have extensions}
                     pDestTblName) ); {desttablename}
      except
        {re-open the table}
        TryOpenExclusive(Table1, True, False);
        raise;
      end;
      {connect new tablename, update filelist:}
      NativeToAnsi(RLocale,pDestTblName,NewTblName);
      TableName := NewTblName;
      with (Self.FindComponent('FileListBox'
      +IntToStr(succ(TabbedNoteBook1.PageIndex)))
      as TFileListBox) do
      begin
        Update;
        {re-opens the table:}
        FileName := TableName;
      end;
    end;
  end;
end;

procedure TMainFrm.DeleteBtnClick(Sender: TObject);
var pSrcTblName: DBITBLNAME;
    hDB: hDBIdb;
begin
  {NOTE this can also be done with Table1.DeleteTable('TblName')}
  if (messageDlg('Do you really want to delete that table?',
                 mtConfirmation,mbOKCancel,0) = mrOK) then
  begin
    with Table1 do
    begin
      AnsiToNative(DBLocale,TableName,pSrcTblName,255);
      hDB := DBHandle;
      Close;
      try
        BDECheck( DBIDeleteTable(hDB, {db handle}
                     pSrcTblName,   {tablename}
                     nil) );  {tabletype, can be nil if filenames have ext.}
      except
        {re-open the table}
        TryOpenExclusive(Table1, True, True);
        raise;
      end;
      {update filelist:}
      TableName := '';
      with (Self.FindComponent('FileListBox'
      +IntToStr(succ(TabbedNoteBook1.PageIndex)))
      as TFileListBox) do
      begin
        Update;
        ItemIndex := -1;
      end;
    end;
  end;
end;

procedure TMainFrm.PackBtnClick(Sender: TObject);
var hDB: hDBIdb;
    pTableDesc: pCRTblDesc; {reqd for Paradox only}
begin
  pTableDesc := nil;
  with Table1 do
  begin
    {Paradox tables:}
    if (StrPas(FTblProps.szTableType) = szPARADOX) then
    begin
      {preparing data for DBIDoRestructure:}
      GetMem(pTableDesc,sizeOf(CRTblDesc));
      {supply nulls (=default) for every optional parameter:}
      FillChar(pTableDesc^,SizeOf(CRTblDesc),0);
      {supply required parameters:}
      AnsiToNative(DBLocale,TableName,pTableDesc^.szTblName,255);
      pTableDesc^.szTblType := FTblProps.szTableType;
      {supply 'our' parameter here for packing:}
      pTableDesc^.bPack := True;
      hDB := DBHandle;
      Close;
      try
        BDECheck( DBIDoRestructure(hDB,      {DB handle}
                                 1,          {no of tbls (has to be 1)}
                                 pTableDesc, {table data desc.}
                                 nil,        {pSaveAs}
                                 nil,        {pKeyViol}
                                 nil,        {pProblem}
                                 False) );   {Analyze only}
      finally
        if pTableDesc <> nil then
          FreeMem(pTableDesc,sizeOf(CRTblDesc));
        TryOpenExclusive(Table1, True, True);
      end;
    end
    else
      {dBase is the simple one here:}
      BDECheck( DBIPackTable(DBHandle,
                             Handle,
                             nil,     {tablename, nil because handle is supplied}
                             szDBASE,
                             True) ); {regen all maintained indices}
  end;
end;

{this is the most complicated and most 'dangerous' one to your data...}
procedure TMainFrm.ProtectBtnClick(Sender: TObject);
var hDB: hDBIdb;
    pTableDesc: pCRTblDesc;
    DoEncrypt: boolean;
    NewPasswrd: TCaption;
    PromptAdd: TCaption;
begin
  NewPasswrd := '';
  pTableDesc := nil;
  {if there is a pw on the table:}
  if FTblProps.bProtected then
    PromptAdd := ' / Ok to remove current'
  else
    PromptAdd := '';
  if not InputQuery('Password',
                    'Enter new password'+PromptAdd,
                     NewPasswrd) then
    System.Exit;
  DoEncrypt := (NewPasswrd <> '');
  if ((DoEncrypt) and not (messageDlg(
                  'You won''t be able to open the table'+#10#13
                  +'   without this password !  Proceed?',
                  mtConfirmation,mbOkCancel,0) = mrOK))
  or ((not DoEncrypt) and (not FTblProps.bProtected)) then
    System.Exit;
  with Table1 do
  try
    {preparing data for DBIDoRestructure:}
    GetMem(pTableDesc,sizeOf(CRTblDesc));

    {supply nulls (=default) for every optional parameter:}
    FillChar(pTableDesc^,SizeOf(CRTblDesc),0);

    {supply indispensable parameters:}
    AnsiToNative(DBLocale,TableName,pTableDesc^.szTblName,255);
    pTableDesc^.szTblType := FTblProps.szTableType;

    {supply parameters for our action here:}
    AnsiToNative(DBLocale,NewPasswrd,pTableDesc^.szPassword,255);
    pTableDesc^.bProtected := DoEncrypt; {supply False to decrypt}

    hDB := DBHandle;
    Close;

    {'do the restructure':}
    BDECheck( DBIDoRestructure(hDB,      {DB handle}
                               1,          {no of tbls (has to be 1)}
                               pTableDesc, {table data desc.}
                               nil,        {pSaveAs}
                               nil,        {pKeyViol}
                               nil,        {pProblem}
                               False) );   {Analyze only}
    finally
      {free memory for table descriptor:}
      if pTableDesc <> nil then
        FreeMem(pTableDesc,sizeOf(CRTblDesc));
      {reopening the table with passworddialog, if it fails,
       supply password with Session.AddPassword:}
      {this is only an example, of course this is not the way
       to code it in a real app...}
      try try
        TryOpenExclusive(Table1, True, True) except end;
      finally
        Session.AddPassword(NewPasswrd);
        TryOpenExclusive(Table1, True, True)
      end;
    end; {with table1 try}
end;

procedure TMainFrm.UserBtnClick(Sender: TObject);
var UserName: DBIName;
    UserNameStr: TCaption;
begin
  BDECheck( DBIGetNetUserName(UserName) );
  if (UserName[0] <> #0) then
    NativeToAnsi(Table1.DBLocale,UserName,UserNameStr)
  else
    UserNameStr := 'Big Chief Empty String <g>';
  showmessage('User is logged to the network as: '+UserNameStr);
end;

procedure TMainFrm.SaveOnIdle(Sender: TObject; var Done: boolean);
begin
  {flushes the BDE buffers when the app is idle:}
  DBIUseIdleTime;
end;

{DBI* functions 'exception-raiser'}
procedure BDECheck(BDERes: DBIResult);
begin
  if (BDERes <> DBIERR_NONE) then
    DBIError(BDERes);
end;

function CloseTableQuery(ADataset: TDataset): boolean;
begin
  Result := True;
  with ADataset do
  begin
    if State in dsEditModes then
      case MessageDlg('Save changes?',mtConfirmation,mbYesNoCancel,0) of
        mrYes: Post;
        mrNo: Cancel;
        mrAbort: Result := False;
      end;
  end;
end;

end. {------ end of code -------}

{ extra: how to trap a specific BDE error: }
 try
   Table1.Open;
 except
   on E:EDBEngineError do
   begin
     if E.Errors[pred(E.ErrorCount)].ErrorCode
         = DBIERR_INDEXOUTOFDATE) then
     begin
       showmessage('Trapped ''Index Out Of Date'' error!');
       SysUtils.Abort; {place your error handler here instead}
     end;
   end
   else
     raise;
 end;


 {not used here; have a look at TSelFldsFrm.SetCenterPos, too}
{this is used for centering a forms position to the form which
 is active when the new form is shown. Useful for dialogs etc.
 (PF is parent form, CF is client form)}
procedure CalcCenterPos(PF, CF: TForm);
var CFTop, CFLeft: smallint;
begin
  CFTop := (PF.Height div 2) - (CF.Height div 2) + PF.Top;
  CFLeft := (PF.Width div 2) - (CF.Width div 2) + PF.Left;
  CF.SetBounds(CFLeft, CFTop, CF.Width, CF.Height);
end;



end.
